/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.CustomCardMaker.gui;

import LegendaryCardMaker.CardMaker;
import LegendaryCardMaker.CustomCardMaker.CustomCardMaker;
import LegendaryCardMaker.CustomCardMaker.CustomCardMakerFrame;
import LegendaryCardMaker.CustomCardMaker.gui.CustomTemplateList;
import LegendaryCardMaker.CustomCardMaker.structure.CustomCard;
import LegendaryCardMaker.CustomCardMaker.structure.CustomProperties;
import LegendaryCardMaker.CustomCardMaker.structure.CustomStructure;
import LegendaryCardMaker.CustomCardMaker.structure.CustomTemplate;
import LegendaryCardMaker.CustomCardMaker.structure.ElementProperty;
import LegendaryCardMaker.LegendaryCardMakerFrame;
import LegendaryCardMaker.exporters.ExportHomeprintProgressBarDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class CustomTemplateEditMenu
extends JMenu
implements ActionListener {
    private CustomTemplateList list = null;
    private JMenu newMenu = new JMenu("New");
    JMenuItem exportJPEGHomeprint = new JMenuItem("Export to JPEG for Homeprint...");

    public CustomTemplateEditMenu(CustomTemplateList list) {
        super("Edit");
        this.list = list;
        if (list.templateList.size() > 1) {
            for (CustomTemplate customTemplate : list.templateList) {
                JMenuItem newItem2 = new JMenuItem(customTemplate.templateDisplayName);
                newItem2.addActionListener(this);
                newItem2.setActionCommand("new_" + customTemplate.templateName);
                this.newMenu.add(newItem2);
            }
            for (CustomStructure customStructure : list.structures) {
                JMenuItem newItem = new JMenuItem(customStructure.displayName);
                newItem.addActionListener(this);
                newItem.setActionCommand("new_struct_" + customStructure.name);
                this.newMenu.add(newItem);
            }
            this.add(this.newMenu);
            this.addSeparator();
        } else if (list.templateList.size() == 1 && list.structures.size() == 0) {
            JMenuItem jMenuItem = new JMenuItem("New " + list.templateList.get((int)0).templateDisplayName);
            jMenuItem.addActionListener(this);
            jMenuItem.setActionCommand("new_" + list.templateList.get((int)0).templateName);
            this.add(jMenuItem);
            this.addSeparator();
        } else if (list.templateList.size() == 0 && list.structures.size() == 1) {
            JMenuItem jMenuItem = new JMenuItem("New " + list.structures.get((int)0).displayName);
            jMenuItem.addActionListener(this);
            jMenuItem.setActionCommand("new_struct_" + list.structures.get((int)0).name);
            this.add(jMenuItem);
            this.addSeparator();
        }
        JMenuItem jMenuItem = new JMenuItem("Edit Card");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("edit_card");
        this.add(jMenuItem);
        JMenuItem deleteItem = new JMenuItem("Delete Card");
        deleteItem.addActionListener(this);
        deleteItem.setActionCommand("delete_card");
        this.add(deleteItem);
        this.addSeparator();
        this.exportJPEGHomeprint.addActionListener(this);
        this.add(this.exportJPEGHomeprint);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int outcome;
        CustomCard cc;
        if (e.getActionCommand().startsWith("new_")) {
            for (CustomTemplate t : this.list.templateList) {
                if (!t.templateName.equals(e.getActionCommand().replace("new_", ""))) continue;
                CustomCard cc2 = new CustomCard();
                cc2.template = t.getCopy();
                cc2.templateName = t.templateName;
                this.list.cardListModel.addElement(cc2);
                this.list.cards.add(cc2);
                LegendaryCardMakerFrame.lcmf.lcm.customCards.add(cc2);
            }
        }
        if (e.getActionCommand().startsWith("edit_card") && (cc = this.list.getSelectedCustomCard()) != null) {
            new CustomCardMakerFrame(cc);
        }
        if (e.getActionCommand().startsWith("delete_card") && (cc = this.list.getSelectedCustomCard()) != null && (outcome = JOptionPane.showOptionDialog(LegendaryCardMakerFrame.lcmf, "Delete Card?", "Delete Hero?", 0, 3, null, null, null)) == 0) {
            LegendaryCardMakerFrame.lcmf.lcm.customCards.remove(cc);
            Set<Map.Entry<String, CustomTemplateList>> entrySet = LegendaryCardMakerFrame.lcmf.customTemplateListSet.entrySet();
            for (Map.Entry<String, CustomTemplateList> entry : entrySet) {
                entry.getValue().removeCustomCard(cc);
            }
        }
        if (e.getSource().equals(this.exportJPEGHomeprint)) {
            cc = this.list.getSelectedCustomCard();
            if (cc == null) {
                return;
            }
            JFileChooser chooser = new JFileChooser();
            if (LegendaryCardMakerFrame.lcmf.lcm.exportFolder != null) {
                File tf = new File(LegendaryCardMakerFrame.lcmf.lcm.exportFolder);
                chooser = new JFileChooser(tf.getParent());
            }
            chooser.setFileSelectionMode(1);
            int outcome2 = chooser.showSaveDialog(this);
            if (outcome2 == 0) {
                File f = chooser.getSelectedFile();
                LegendaryCardMakerFrame.lcmf.lcm.exportFolder = f.getAbsolutePath();
                f.mkdirs();
                try {
                    ArrayList<CardMaker> cardMakers = new ArrayList<CardMaker>();
                    for (CustomCard hc : this.list.cards) {
                        CustomCardMaker hm = new CustomCardMaker();
                        hm.setCard(hc);
                        int numberInDeck = 1;
                        ElementProperty numberInDeckProp = cc.template.getProperty(CustomProperties.NUMBERINDECK);
                        if (numberInDeckProp != null) {
                            try {
                                numberInDeck = Integer.parseInt(numberInDeckProp.getValue());
                            }
                            catch (Exception ex) {
                                numberInDeck = 1;
                            }
                        }
                        int i = 0;
                        while (i < numberInDeck) {
                            cardMakers.add(hm);
                            ++i;
                        }
                    }
                    LegendaryCardMakerFrame.lcmf.applicationProps.put("lastExportDirectory", chooser.getSelectedFile().getAbsolutePath());
                    ExportHomeprintProgressBarDialog exporter = new ExportHomeprintProgressBarDialog(LegendaryCardMakerFrame.lcmf.lcm.getCardCount(), LegendaryCardMakerFrame.lcmf.lcm, f, cardMakers);
                    exporter.createAndShowGUI();
                    LegendaryCardMakerFrame.lcmf.saveProperties();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(LegendaryCardMakerFrame.lcmf, "Error! " + ex.getMessage());
                }
            }
        }
    }
}

